/*
	File:		BevelImageAPIWindow.cp

	Contains:	Bevel Button content type examples.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

//
//	This file implements a dialog demonstrating the different
//	methods of setting bevel button content types, such as pictures,
//	icons, and text.
//

#include "Appearance.h"
#include "BevelImageAPIWindow.h"
#include "AppearanceHelpers.h"

void	HandleBevelDialog( DialogPtr dialog, short itemHit );

void	EnableDisableAll( DialogPtr dialog, Boolean enable );
void	SetControlValues( DialogPtr dialog, short value );
void	SetUpBevelDialog( DialogPtr dialog );

#define DIRECT		1

enum {
	kBevelButton		= 1,
	kImageWell			= 2,

	kBBIconSuite		= 4,
	kBBColorIcon		= 5,
	kBBPicture			= 6,
	kBBTextOnly 		= 7,

	kIWIconSuite		= 8,
	kIWColorIcon		= 9,
	kIWPicture			= 10,
	
	kIWIconSuiteHandle	= 11,
	kIWColorIconHandle	= 12,
	kIWPictureHandle	= 13,
	
	kBBIconSuiteHandle	= 14,
	kBBColorIconHandle	= 15,
	kBBPictureHandle	= 16
};

BevelImageAPIWindow::BevelImageAPIWindow() : BaseDialog( 1002 )
{
	if ( fWindow )
	{
		ShowWindow( fWindow );
		
		GetIconSuite( &fIconSuite, 128, svAllAvailableData );
		fColorIcon = GetCIcon( 128 );
	}
}

BevelImageAPIWindow::~BevelImageAPIWindow()
{
	if ( fWindow )
	{
		if ( fIconSuite )
			DisposeIconSuite( fIconSuite, true );
		
		if ( fColorIcon )
			DisposeCIcon( fColorIcon );
	}
}

void
BevelImageAPIWindow::HandleItemHit( short itemHit )
{
	ControlHandle				control;
	ControlButtonContentInfo	info;
	OSErr						err;
	
	switch ( itemHit ) {
		case kBBIconSuite:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentIconSuiteRes;
			info.u.resID = 128;
			err = SetBevelButtonContentInfo( control, &info );
			
			(**control).contrlTitle[ 0 ] = 0;
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kBBColorIcon:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentCIconRes;
			info.u.resID = 128;
			err = SetBevelButtonContentInfo( control, &info );
			
			(**control).contrlTitle[ 0 ] = 0;

			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kBBPicture:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentPictRes;
			info.u.resID = 129;
			err = SetBevelButtonContentInfo( control, &info );
			
			(**control).contrlTitle[ 0 ] = 0;

			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kBBTextOnly:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentTextOnly;
			info.u.resID = 0;
			err = SetBevelButtonContentInfo( control, &info );
			
			SetControlTitle( control, "\pTesting" );
							
			break;
			

		case kBBIconSuiteHandle:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentIconSuiteHandle;
			info.u.iconSuite = fIconSuite;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kBBColorIconHandle:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentCIconHandle;
			info.u.cIconHandle = fColorIcon;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kBBPictureHandle:
			GetDialogItemAsControl( fWindow, kBevelButton, &control );
			
			info.contentType = kControlContentPictHandle;
			info.u.picture = GetPicture( 129 );
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
		case kIWIconSuite:
			GetDialogItemAsControl( fWindow, kImageWell, &control );
			
			info.contentType = kControlContentIconSuiteRes;
			info.u.resID = 128;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kIWColorIcon:
			GetDialogItemAsControl( fWindow, kImageWell, &control );
			
			info.contentType = kControlContentCIconRes;
			info.u.resID = 128;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kIWPicture:
			GetDialogItemAsControl( fWindow, kImageWell, &control );
			
			info.contentType = kControlContentPictRes;
			info.u.resID = 129;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;			

		case kIWIconSuiteHandle:
			GetDialogItemAsControl( fWindow, kImageWell, &control );
			
			info.contentType = kControlContentIconSuiteHandle;
			info.u.iconSuite = fIconSuite;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kIWColorIconHandle:
			GetDialogItemAsControl( fWindow, kImageWell, &control );
			
			info.contentType = kControlContentCIconHandle;
			info.u.cIconHandle = fColorIcon;
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;
		
		case kIWPictureHandle:
			GetDialogItemAsControl( fWindow, kImageWell, &control );
			
			info.contentType = kControlContentPictHandle;
			info.u.picture = GetPicture( 129 );
			err = SetBevelButtonContentInfo( control, &info );
			
			if ( err == noErr )
				DrawOneControl( control );
				
			break;			
	}
}
